//
//  GSAlert.h
//  GlyphsCore
//
//  Created by Georg Seifert on 22.01.12.
//  Copyright 2012 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface GSAlert : NSWindowController <NSWindowDelegate>

@property (nonatomic, strong) NSString *messageText;
@property (nonatomic, strong) NSString *informativeText;
@property (nonatomic, strong) NSAttributedString *attributedInformativeText;
@property (nonatomic) BOOL isWide;

@property (nonatomic, weak) IBOutlet NSButton *defaultButton;
@property (nonatomic, weak) IBOutlet NSButton *secondButton;
@property (nonatomic, weak) IBOutlet NSStackView *messageStackView;
@property (nonatomic, weak) IBOutlet NSImageView *imageView;
@property (nonatomic, strong) NSTextView *textView;
@property (nonatomic, weak) IBOutlet NSLayoutConstraint *messageWidthConstraint;
@property (nonatomic, assign) NSLayoutConstraint *messageHeightConstraint;

@property (nonatomic, strong) NSString *defaultButtonTitle;
@property (nonatomic, strong) NSString *secondButtonTitle;

@property (nonatomic, strong) NSString *suppressionDefaultsKey;

@property (nonatomic, assign) BOOL bigSurStyle;

- (NSModalResponse)runModal;

- (void)showWindowWithCompletion:(void (^)(NSModalResponse response))completion;
/**
 @param variableInfo This parameter is optional.
 */
- (void)populateFieldsFromException:(NSException *)exception
					   variableInfo:(NSString *)variableInfo;

@end
